#include <vector>
#include <iostream>
#include <algorithm>
#include <set>

#define int long long
using namespace std;
typedef long long ll;
typedef long double ld;
const ll MAX_COORD = 1e9;


pair<ld, ld> intersect(pair<ll, ll> a1, pair<ll, ll> b1, pair<ll, ll> a2, pair<ll, ll> b2) {
    ll ak1 = (a1.second - b1.second);
    ll bk1 = (b1.first - a1.first);
    ll ck1 = -ak1 * a1.first - bk1 * a1.second;

    ll ak2 = (a2.second - b2.second);
    ll bk2 = (b2.first - a2.first);
    ll ck2 = -ak2 * a2.first - bk2 * a2.second;

    if (ak1 * bk2 == ak2 * bk1) {
        return {2 * MAX_COORD, 2 * MAX_COORD};
    }
    ld y = ld(-ck2 * ak1 + ck1 * ak2) / (bk2 * ak1 - bk1 * ak2);
    ld x = ld(ck1 * bk2 - ck2 * bk1) / (ak2 * bk1 - ak1 * bk2);
    if (
            min(a1.first, b1.first) <= x && x <= max(a1.first, b1.first) &&
            min(a2.first, b2.first) <= x && x <= max(a2.first, b2.first) &&
            min(a1.second, b1.second) <= y && y <= max(a1.second, b1.second) &&
            min(a2.second, b2.second) <= y && y <= max(a2.second, b2.second)
            ) {
        return {x, y};
    }
    return {2 * MAX_COORD, 2 * MAX_COORD};
}


vector<vector<int>> g;
vector<bool> used;
set<pair<int, int>> rooster;

int res = 1;

void dfs(int v, int p) {
    used[v] = true;
    for (int u : g[v]) {
        if (u == p) continue;
        auto e = make_pair(u, v);
        if (u > v) swap(e.first, e.second);
        if (used[u]) {
            if (rooster.count(e) == 0) {
                res++;
                rooster.insert(e);
            }
        } else dfs(u, v);
    }
}


void solve() {
    rooster = {};
    res = 1;
    g = {};
    int sn;
    cin >> sn;
    vector<vector<int>> sint(sn, vector<int>(sn, -1));
    vector<pair<pair<int, int>, pair<int, int>>> segs(sn);
    for (int i = 0; i < sn; i++) {
        cin >> segs[i].first.first >> segs[i].first.second >> segs[i].second.first >> segs[i].second.second;
    }
    int n = 0;

    for (int i = 0; i < sn; i++) {
        vector<pair<pair<ld, ld>, int>> pts;
        for (int j = 0; j < sn; j++) {
            if (i == j) continue;
            if (j < i) {
                if (sint[i][j] == -1) continue;
                pts.emplace_back(intersect(segs[i].first, segs[i].second, segs[j].first, segs[j].second), sint[i][j]);
            } else {
                auto p = intersect(segs[i].first, segs[i].second, segs[j].first, segs[j].second);
                if (p.first <= MAX_COORD) {
                    sint[i][j] = sint[j][i] = n;
                    n++;
                    g.emplace_back();
                    pts.emplace_back(intersect(segs[i].first, segs[i].second, segs[j].first, segs[j].second),
                                     sint[i][j]);
                }
            }
        }
        sort(pts.begin(), pts.end());
        for (int ind = 0; ind + 1 < pts.size(); ind++) {
            g[pts[ind].second].push_back(pts[ind + 1].second);
            g[pts[ind + 1].second].push_back(pts[ind].second);
        }
    }
    used.assign(n, false);
    for (int i = 0; i < n; i++) {
        if (!used[i]) dfs(i, -1);
    }
    cout << res;
//    for (int i = 0; i < n; i++) {
//        cout << i << ": ";
//        for (int j : g[i]) cout << j << ' ';
//        cout << endl;
//    }
}


int32_t main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
        cout << '\n';
    }
}
